IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Cbtes_Ctas_Contables_Generar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Cbtes_Ctas_Contables_Generar] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Ctas_Contables_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON
 
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Ctas_Contables_Generar_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    EXEC [CPJ_Cbtes_Ctas_Contables_Generar_] @pJson
 	RETURN
END
 
/*
 * LOG VERSIONES:
 * 05/05/2022: En el Debe cuando habia un producto desplegado en meses ponia el importe de solo un periodo
 * 30/6/2022: En el debe se coloca centro de costo vacio

 * 3/11/2022 Centros de costos
   Asi_CC_Req_Resul   par global de todas las ctas.result

   Prioridades para centro de costos del producto
           CBT:Id_Centro_Costo
           CLI:Id_Centro_Costo
           SUC:Id_Centro_Costo
       deberiamos recibir el CBT:Id_Centro_Costo del cbte para poder tomar aca    

*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Trans				INT
DECLARE @pFlagRegenerar			TINYINT
DECLARE @pRtaMsjStored			TINYINT					--01/12/2022 Agregado	

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pFlagRegenerar				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagRegenerar')), 0)
SET @pRtaMsjStored				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'RtaMsjStored')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion de Variables*/
DECLARE @Flag_Compromete_Asientos	SMALLINT
DECLARE @Flag_Compromete_Factura	SMALLINT
DECLARE @Flag_Compromete_Trans_Fondos SMALLINT
DECLARE @Flag_Compromete_Recibos	SMALLINT
DECLARE @Flag_Compromete_Pagos		SMALLINT

DECLARE @Fecha_Cbte					DATETIME
DECLARE @Id_Cliente					INT
DECLARE @Id_Tipo_Cbte				CHAR(4)
DECLARE @Id_Cta_Contable			INT
DECLARE @Alias						INT
DECLARE @Alias_Monedas				INT
DECLARE @Alias_Tipo_Valor			INT
DECLARE @Alias_Tipo_Valor_Elec		INT
DECLARE @Flag_Electronico			INT
DECLARE @Alias_Pago_Cta				INT
DECLARE @Id_Asiento					INT
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Id_Ejercicio_Corresp		INT
DECLARE @Id_Plan_Cta_Corresp		INT
DECLARE @Imp_Total_Cbte				DECIMAL(20,2)
DECLARE @Debe						DECIMAL(20,2)
DECLARE @Haber						DECIMAL(20,2)
DECLARE @Id_Producto				VARCHAR(14)
DECLARE @Id_Tipo_Reten				VARCHAR(10)
DECLARE @NroItem					SMALLINT
DECLARE @CMC_UltItem				SMALLINT
DECLARE @CMC_UltId_Periodo_Caja		INT
DECLARE @CMC_Id_Concepto			INT
DECLARE @VAL_UltId_Valor			INT
DECLARE @VAL_UltId_Periodo_Caja		INT
DECLARE @VAL_Id_Tipo_Val			CHAR(3)
DECLARE @Id_Cond_Pago				SMALLINT
DECLARE @VAL_Id_Periodo_Caja		INT
DECLARE @CP_Id_Caja					INT
DECLARE @ID_TARJETA                 VARCHAR(10)
DECLARE @ID_CTA_BANCO               SMALLINT
DECLARE @pId_Trans_ORIGEN            INT
DECLARE @Parametro_Asiento_Vtas_Ptos INT
DECLARE @Cbtes_Items_Imp_Final		DECIMAL(20,2)
DECLARE @Id_Caja					INT
DECLARE @Imp_Original				DECIMAL (20,2) -- Agregado el 20220527
DECLARE @IMPORTE					DECIMAL (20,2) -- Agregado el 20220527
DECLARE @IMPORTE_Pago_Cta			DECIMAL (20,2) 
DECLARE @IMPORTE_Pago_Cta_Tomado	DECIMAL (20,2) 
DECLARE @Importe_Fpago				DECIMAL (20,2) -- Agregado el 20220712
DECLARE @Total_Debe					DECIMAL (20,2) -- Agregado el 20220712 
Declare @Total_haber                Decimal (20,2)
Declare @Alias_a_Cta                Int


DECLARE @Id_Moneda					CHAR(3)			
/*declaracion asiento de compras*/

DECLARE @Signo	INT
		,@Flag_Compromete_Compras SMALLINT
		,@Id_Iva	CHAR(3)
		,@Alias_D SmallInt
		,@Alias_H SmallInt
		,@ID_Cta_Debe Int
		,@ID_Cta_Haber Int
		,@IMP_GRAVADO DECIMAL(20,2)
		,@IMP_IVA DECIMAL(20,2)
		,@Id_Proveedor	INT
		,@Fecha	DATETIME
		,@ASI_Comp_x_Items INT
		,@Alias_D_IVA INT 
		,@ID_Cta_Debe_IVA INT
		,@IMPORTE_NC DECIMAL(20,2)


/*FIN Declaracion de Variables*/

SET @VAL_Id_Periodo_Caja = ISNULL((SELECT MAX(Id_Periodo_Caja) FROM Valores_Mov WHERE Id_Trans = @pId_Trans), 0)
SET @CP_Id_Caja = ISNULL((SELECT Id_Caja FROM Cajas_Periodos WHERE Id_Periodo_Caja = @VAL_Id_Periodo_Caja), 0)		
Set @Alias_a_Cta = CAST( dbo.CF_xParam('Alias_Pago_a_Cta') AS Int) 

BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
 
	IF(@pModoDebug = 1)
	BEGIN

		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Ingreso a Stored Procedure: CPJ_Cbtes_Ctas_Contables_Generar'
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Parametros:'
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + ' Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) + ' FlagRegenerar: ' + CONVERT(VARCHAR(10), @pFlagRegenerar)
	END

	/*===================================================================*/

	IF(@pId_Trans = 0)   RAISERROR ('Id_trans can not be zero.', 16,  1 ) 
	
	/*===================================================================*/	

	SET @Parametro_Asiento_Vtas_Ptos = dbo.CF_xParam('Asiento_Vtas_Ptos')

	IF(@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Parametro_Asiento_Vtas_Ptos: ' + CONVERT(VARCHAR(10), @Parametro_Asiento_Vtas_Ptos)
	END

	/*===================================================================*/	

	IF(@pFlagRegenerar = 1)
	BEGIN
		DELETE FROM Cbtes_Ctas_Contables WHERE Id_Trans = @pId_Trans
	END


	/*************************************************************************************************/

	SET @Id_Tipo_Cbte	= (SELECT Id_Tipo_Cbte FROM Cbtes WHERE Id_Trans = @pId_Trans)

	SELECT  @Flag_Compromete_Asientos		= ISNULL(Compromete_Asientos, 0),
			@Flag_Compromete_Factura		= ISNULL(Compromete_Factura, 0),
			@Flag_Compromete_Trans_Fondos	= ISNULL(Compromete_Trans_Fondos, 0),
			@Flag_Compromete_Recibos		= ISNULL(Compromete_Recibos, 0),
            @Flag_Compromete_Compras        = ISNULL(Compromete_Compras, 0),
			@Flag_Compromete_Pagos			= ISNULL(Compromete_Pagos,0)
			FROM Cbtes_Tipos
			WHERE 
			Id_Tipo_Cbte = @Id_Tipo_Cbte

	/*************************************************************************************************/

	IF(@Flag_Compromete_Asientos = 0)
	BEGIN
		IF @pFlagUsarTrans <> 0 
		BEGIN
			COMMIT
		END
		SET @rtaMsjStored = 'El Cbte. no Genera Asiento'

		IF (@pRtaMsjStored = 0)
		BEGIN

			SELECT	 0				AS ErrorNumber 
					,0				AS ErrorSeverity  
					,0				AS ErrorState 
					,0				AS ErrorProcedure  
					,0				AS ErrorLine		
					,@rtaMsjStored	AS ErrorMessage
		END
			
		RETURN 0
	END

	/*************************************************************************************************/

	SELECT  @Id_Cliente		= ISNULL(Id_Cliente, 0),
			@Fecha_Cbte		= ISNULL(Fecha, '19000101'),
			@Imp_Total_Cbte	= ISNULL(Imp_Total, 0)
			FROM Cbtes
			WHERE 
			Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SET @Id_Ejercicio_Corresp = (SELECT Id_Ejercicio FROM Plan_Ctas_Ejercicios WHERE Fecha_Inicio <= @Fecha_Cbte AND DATEADD(dd, 1, Fecha_Cierre) > @Fecha_Cbte)
	SET @Id_Plan_Cta_Corresp = (SELECT Id_Plan_Cta FROM Plan_Ctas WHERE Id_Ejercicio = @Id_Ejercicio_Corresp)
	IF(@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Nro. de Ejercicio: ' + CONVERT(VARCHAR(10), @Id_Ejercicio_Corresp) + '. Nro. Plan de Cuenta: ' + CONVERT(VARCHAR(10), @Id_Plan_Cta_Corresp)
	END

/*************************************************************************************************/

	IF(@Flag_Compromete_Factura = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Compromete Factura'
		END
	
		SET @Id_Cond_Pago = (SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
		IF(@Id_Cond_Pago NOT IN (1)) /*Si no es contado*/
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Cond. Pago NO ES CONTADO. @Id_Cond_Pago: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago)
			END

			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: DEBE'
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Parametro_Asiento_Vtas_Ptos: ' + CONVERT(VARCHAR(10), @Parametro_Asiento_Vtas_Ptos)
			END

			IF(@Parametro_Asiento_Vtas_Ptos = 0)
			BEGIN
				SET @Alias = (SELECT ISNULL(Id_Alias_Cta_Cont_Venta, 0) FROM Clientes WHERE Id_Cliente = @Id_Cliente)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
                IF (SELECT 1 FROM Pla_Ctas_Cuentas_Contables WHERE Id_Cta_Contable = @Id_Cta_Contable AND Tipo IN ('-','+') ) = 1
				   SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Clientes WHERE Id_Cliente = @Id_Cliente),'')
                ELSE
				   SET @Id_Centro_Costo ='' /* 30/6/22 Pongo en CC vacio en el Debe*/ 

				SET @Debe = @Imp_Total_Cbte
				SET @NroItem = 1
				IF(@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
				END

				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,			0/*Haber*/,			''/*Observacion*/,
				@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
				@NroItem)

			END
			ELSE
			BEGIN
				DECLARE curGenCtaCteDebexProduc CURSOR FOR 							
				SELECT DISTINCT Id_Producto, SUM(Imp_Final) AS Imp_Final FROM Cbtes_Items WHERE Id_Trans = @pId_Trans GROUP BY Id_Producto
				--05/05/2022 Se agrupa para items de meses continuos, antes ponia en el debe solo un item por el monto de un periodo
				--SELECT DISTINCT Id_Producto, Imp_Final FROM Cbtes_Items WHERE Id_Trans = @pId_Trans
				SET @NroItem = 0
				OPEN curGenCtaCteDebexProduc
				FETCH NEXT FROM curGenCtaCteDebexProduc INTO @Id_Producto, @Cbtes_Items_Imp_Final
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Id_Producto: ' + @Id_Producto + '. Imp_Final: ' + CONVERT(VARCHAR(20), @Cbtes_Items_Imp_Final)
					END

					SET @Alias = (SELECT ISNULL(Id_Alias_Cta_Deudores, 0) FROM Productos WHERE Id_Producto = @Id_Producto)
					SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
					--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)

	                IF (SELECT 1 FROM Pla_Ctas_Cuentas_Contables WHERE Id_Cta_Contable = @Id_Cta_Contable AND Tipo IN ('-','+') ) = 1
					   SET @Id_Centro_Costo = ISNULL((SELECT ISNULL(Id_Centro_Costo, '') FROM Productos WHERE Id_Producto = @Id_Producto),'')
	                ELSE
					   SET @Id_Centro_Costo ='' /* 30/6/22 Pongo en CC vacio en el Debe*/ 

				   	SET @Debe = @Cbtes_Items_Imp_Final
					SET @NroItem = @NroItem + 1
					IF(@pModoDebug = 1)
					BEGIN
						PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
					END

					INSERT INTO Cbtes_Ctas_Contables
					(Id_Trans,		Id_Cta_Contable,	Fecha,
					Debe,			Haber,				Observacion,
					Alias,			Id_Asiento,			Id_Centro_Costo,
					Item)
					VALUES									
					(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
					@Debe,			0/*Haber*/,			''/*Observacion*/,
					@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
					@NroItem)

					FETCH NEXT FROM curGenCtaCteDebexProduc INTO @Id_Producto, @Cbtes_Items_Imp_Final
				END 
				CLOSE curGenCtaCteDebexProduc;
				DEALLOCATE curGenCtaCteDebexProduc;
			END
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Cond. Pago ES CONTADO'
			END

			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: DEBE'
			END

					
			SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), 0)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Alias = @Alias AND Id_Plan_Cta = @Id_Plan_Cta_Corresp)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Cajas WHERE Id_Caja = @CP_Id_Caja), '')
			SET @Debe = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
		
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe,			0/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
		END
	
		/*Insert: Cuenta Contable: HABER*/
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: HABER'
		END
	
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Productos'
		DECLARE curGenCtaCteHaber CURSOR FOR 
			SELECT DISTINCT Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaber
		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Alias_Cta_Cont FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Productos WHERE Id_Producto = @Id_Producto),'')
			SET @Haber = (SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto = @Id_Producto)
			SET @NroItem = @NroItem + 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Producto: ' + @Id_Producto + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		END 
		CLOSE curGenCtaCteHaber;
		DEALLOCATE curGenCtaCteHaber;
		/*FIN Insert: Cuenta Contable: HABER*/

		IF(@pModoDebug = 1)
		BEGIN
	 		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Percepciones'	
		END

		DECLARE curGenCtaCteHaberPercep CURSOR FOR 
			SELECT DISTINCT Id_Tipo_Reten	FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaberPercep
		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ''
			SET @Haber = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1			
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteHaberPercep;
		DEALLOCATE curGenCtaCteHaberPercep;

		IF(@pModoDebug = 1)
		BEGIN	
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Iva'
		END
		SET @Alias = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Iva_Debito_Fiscal')
		SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
		--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
		SET @Id_Centro_Costo = ''
		SET @Haber = (SELECT SUM(Imp_Iva) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto IN (SELECT Id_Producto FROM Productos WHERE Id_Iva IN (SELECT Id_Iva FROM Productos_TasaIva WHERE (Porc1 <> 0 OR Porc1 IS NOT NULL))))
	
		IF(@Haber <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
			
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END
	
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN Compromete Factura'
	END /*IF(@Flag_Compromete_Factura = 1)*/

/*************************************************************************************************/

IF(@Flag_Compromete_Factura =-1) /*NC*/
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Compromete Factura -1 ES NC'
		END

		SET @Id_Cond_Pago = (SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
		IF(@Id_Cond_Pago NOT IN (1)) /*Si no es contado*/
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Cond. Pago NO ES CONTADO. @Id_Cond_Pago: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago)
			END
		
			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: DEBE'
			END
			SET @Alias = (SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Centro_Costo FROM Clientes WHERE Id_Cliente = @Id_Cliente),'')
			SET @Haber = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0,			    @Haber/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: HABER (SI la Cond. Pago NO es Contado)*/
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Cond. Pago ES CONTADO'
			END
		
			/*Insert: Cuenta Contable: HABER (SI la Cond. Pago ES Contado)*/
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: HABER'
			END
	
			SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), 0)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Alias = @Alias AND Id_Plan_Cta = @Id_Plan_Cta_Corresp)
			SET @Id_Centro_Costo = ISNULL((SELECT  Id_Centro_Costo FROM Cajas WHERE Id_Caja = @CP_Id_Caja), '')
			SET @Haber = @Imp_Total_Cbte
			SET @NroItem = 1
			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
		
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0,			    @Haber/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: HABER (SI la Cond. Pago ES Contado)*/
		END
	
		/*Insert: Cuenta Contable: DEBE*/
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: DEBE'
		END
	
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Productos'
		DECLARE curGenCtaCteHaber CURSOR FOR 
			SELECT DISTINCT Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaber
		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Alias_Cta_Cont FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = (SELECT Id_Centro_Costo FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Debe = (SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto = @Id_Producto)
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Producto: ' + @Id_Producto + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,		0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		END 
		CLOSE curGenCtaCteHaber;
		DEALLOCATE curGenCtaCteHaber;
		/*FIN Insert: Cuenta Contable: DEBE*/

		IF(@pModoDebug = 1)
		BEGIN	
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Percepciones'	
		END

		DECLARE curGenCtaCteHaberPercep CURSOR FOR 
			SELECT DISTINCT Id_Tipo_Reten	FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaberPercep
		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
			--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ''
			SET @Debe = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1

			IF(@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
			END
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,		0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteHaberPercep;
		DEALLOCATE curGenCtaCteHaberPercep;
	
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Iva'
		SET @Alias = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Iva_Debito_Fiscal')
		SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
		--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
		SET @Id_Centro_Costo = ''
		SET @Debe = (SELECT SUM(Imp_Iva) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto IN (SELECT Id_Producto FROM Productos WHERE Id_Iva IN (SELECT Id_Iva FROM Productos_TasaIva WHERE (Porc1 <> 0 OR Porc1 IS NOT NULL))))
	
		IF(@Debe <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe/*Debe*/,	0,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END
		IF(@pModoDebug = 1)
		BEGIN	
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN Compromete Factura -1 '
		END
END /*IF(@Flag_Compromete_Factura = -1  NC)*/

/*************************************************************************************************/

	IF(@Flag_Compromete_Trans_Fondos = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Compromete Transferencia de Fondos'
		END

		/*Insert: Cuenta Contable: DEBE*/
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: DEBE'
		SET @CMC_UltItem = ISNULL((SELECT MAX(Item) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans), 0)
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Cajas_Mov_Conceptos. Ult. Item Generado: ' + CONVERT(VARCHAR(10), @CMC_UltItem)
	
		IF(@CMC_UltItem <> 0)
		BEGIN
			SET @CMC_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Item = @CMC_UltItem), 0)
		
			----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items por cada concepto del Periodo de Caja: ' + CONVERT(VARCHAR(10), @CMC_UltId_Periodo_Caja)
			DECLARE curGenCtaCteDebe_CMC CURSOR FOR 
				SELECT DISTINCT Id_Concepto FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans
								AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja
		
			SET @NroItem = 0
		
			OPEN curGenCtaCteDebe_CMC
			FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			WHILE @@FETCH_STATUS = 0
			BEGIN
			    SET @Haber = 0
				SET @debe = 0
				SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Conceptos WHERE Id_Concepto = @CMC_Id_Concepto),0)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)	
				SET @Debe = (SELECT ISNULL(SUM(Importe), 0) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Id_Concepto = @CMC_Id_Concepto AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Concepto: ' + CONVERT(VARCHAR(10), @CMC_Id_Concepto) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				 Debe,			Haber,				Observacion,
				 Alias,			Id_Asiento,			Id_Centro_Costo,
				 Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				 @Debe,			@Haber,			''/*Observacion*/,
				 @Alias,			0/*Id_Asiento*/,	''/*Id_Centro_Costo*/,
				 @NroItem)

				FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			END 
			CLOSE curGenCtaCteDebe_CMC;
			DEALLOCATE curGenCtaCteDebe_CMC;
		END /*IF(@CMC_UltItem <> 0)*/
	
		/*Insert: Cuenta Contable: HABER*/
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion Cuenta Contable: HABER'
		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores WHERE Id_Trans = @pId_Trans), 0)
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
	
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
			SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Valor = @VAL_UltId_Valor), 0)
		
			----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items por cada Id_Tipo_Val del Periodo de Caja: ' + CONVERT(VARCHAR(10), @VAL_UltId_Periodo_Caja)
			DECLARE curGenCtaCteHaber_Val CURSOR FOR 
				SELECT DISTINCT Id_Tipo_Val 
				FROM Valores 
				WHERE 
				Id_Trans = @pId_Trans
				AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja
		
			OPEN curGenCtaCteHaber_Val
			FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tipos WHERE Id_Tipo_Val = @VAL_Id_Tipo_Val), 0)
				SET @Id_Cta_Contable = ISNULL((SELECT dbo.CF_Cta_Cont(@Alias,@Fecha_Cbte)),0)
				--SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
				SET @Haber = (SELECT SUM(Importe) FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Tipo_Val = @VAL_Id_Tipo_Val AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			END 
			CLOSE curGenCtaCteHaber_Val;
			DEALLOCATE curGenCtaCteHaber_Val;		
		END
	
		----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN Compromete Transferencia de Fondos'
	END /*IF(@Flag_Compromete_Trans_Fondos = 1)*/

/*************************************************************************************************/
--ASIENTO RECIBO

	IF(@Flag_Compromete_Recibos = 1)
	BEGIN
		IF(@pModoDebug = 1)
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +CONVERT(VARCHAR(20),GETDATE(),126) +' Compromete Recibos'

	    DECLARE @Tomar_Asiento_Cbte SMALLINT 
		SET @Tomar_Asiento_Cbte = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Tomar_Asiento_Cbte') 

		SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT TOP 1 Id_Periodo_Caja FROM Cajas_Mov WHERE Id_Trans = @pId_Trans ORDER BY Renglon_Nro),0)
		SET @Id_Caja                = ISNULL((SELECT ISNULL(id_Caja,0) FROM Cajas_Periodos WHERE id_periodo_caja= @VAL_UltId_Periodo_Caja), 0)				

	    SET @NroItem = 0
		 
		SET @Id_Moneda =  ISNULL((SELECT ID_MONEDA FROM CBTES WHERE Id_Trans = @pId_Trans), 'PES')


		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores_Mov WHERE Id_Trans = @pId_Trans), 0)
        IF(@pModoDebug = 1)
		   PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'INICIALIZO'

		IF(@VAL_UltId_Valor <> 0)
	    BEGIN
			DECLARE curGenCtaDEBE_Val CURSOR FOR 
					SELECT DISTINCT V.Id_Tipo_Val,ISNULL(V.ID_TARJETA,''),ISNULL(V.ID_CTA_BANCO,0),ISNULL(V.Id_Moneda,''),ISNULL(V.Flag_Electronico,0)
					FROM Valores_MOV M, VALORES V 
					WHERE 
					M.Id_Trans = @pId_Trans
					AND M.ID_VALOR = V.ID_VALOR
					AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja

			OPEN curGenCtaDEBE_Val
			FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO,@Id_Moneda,@Flag_Electronico
			WHILE @@FETCH_STATUS = 0
			BEGIN
                IF(@pModoDebug = 1)
		            PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'RECORRO CURSOR VALORES'
			    SET @Alias = 0 

				SET @Alias = ISNULL((SELECT ISNULL(MAX(id_alias_cta_cont),0) FROM Cajas_Ctas_Cont WHERE Id_caja=@Id_Caja 
									AND  id_tipo_val=@VAL_Id_Tipo_Val
									AND Id_Moneda = @Id_Moneda), 0)
				IF @Alias = 0
				BEGIN
					IF @VAL_Id_Tipo_Val = 'DB' OR @VAL_Id_Tipo_Val = 'CHP' OR @VAL_Id_Tipo_Val = 'CTA' 
						  SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Bancos_Ctas WHERE Id_Cta_Banco = @ID_CTA_BANCO), 0)

					IF @VAL_Id_Tipo_Val = 'TAR' OR @VAL_Id_Tipo_Val = 'CUP'
						  SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tarjetas_Cred WHERE ID_TARJETA = @ID_TARJETA), 0)
				END

				IF @Alias = 0
					SET @Alias = ISNULL((SELECT ISNULL(MAX(Id_Alias_Cta_Cont),0) FROM Valores_Monedas WHERE Id_Moneda=@Id_Moneda), 0)

				IF @Alias = 0
				BEGIN
					SET @Alias = ISNULL((SELECT ISNULL(MAX(id_alias_cta_cont),0) FROM Valores_Tipos WHERE Id_Tipo_Val=@VAL_Id_Tipo_Val), 0)
					IF @Alias <> 0 AND @Flag_Electronico <> 0 AND ((SELECT ISNULL(Id_Alias_Cta_Cont_Electr,0)  FROM Valores_Tipos WHERE Id_Tipo_Val=@VAL_Id_Tipo_Val ) <> 0)
						SET @Alias = (SELECT ISNULL(Id_Alias_Cta_Cont_Electr,0)  FROM Valores_Tipos WHERE Id_Tipo_Val=@VAL_Id_Tipo_Val )
				END

				IF @Alias = 0
				   SET @Alias = ISNULL((SELECT ISNULL(id_cta_contable,0) FROM  cajas  WHERE id_caja= @Id_Caja),0)	

				IF @Alias = 0
				   SET @Alias = CONVERT(INT,dbo.CF_xParam('Cuenta_Caja'))


				SET @Id_Cta_Contable = 	  (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))

                --SET @Id_Cta_Contable = 0
				SET @NroItem = @NroItem + 1
			    SET @Id_Centro_Costo = ''
			    SET @Debe = (SELECT SUM(V.Importe) FROM Valores V, Valores_Mov M WHERE M.Id_Trans = @pId_Trans AND M.id_valor = V.Id_Valor And V.Id_Tipo_Val = @VAL_Id_Tipo_Val AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja AND ISNULL(V.Id_Tarjeta,'') = @ID_TARJETA AND ISNULL(V.Id_Cta_Banco,0) = @Id_Cta_Banco)
	            SET @Total_Debe = @Debe
				----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,		0,				''/*Observacion*/,
				@Alias,		0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO,@Id_Moneda,@Flag_Electronico
			END 
			CLOSE curGenCtaDEBE_Val;
			DEALLOCATE curGenCtaDEBE_Val;		
		END
        IF(@pModoDebug = 1)
		   PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN CURSOR VALORES'

		DECLARE curGenCtaCteDEBEPercep CURSOR FOR 
			SELECT R.Id_Tipo_Reten,R.Importe,T.Id_Cta_Contable
					FROM Cbtes_Reten R, Cbtes_Reten_Tipos T
					WHERE R.Id_Trans = @pId_Trans AND R.Id_Tipo_Reten =  T.Id_Tipo_Reten

		OPEN curGenCtaCteDEBEPercep
		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten,@IMPORTE,@Alias_H
		WHILE @@FETCH_STATUS = 0
		BEGIN

		 	IF(@pModoDebug = 1)
		       PRINT CONVERT(VARCHAR(20),GETDATE(),126) +' @Alias_H:' +  CONVERT(VARCHAR,@Alias_H)		


		    SET @ID_Cta_Haber = (SELECT dbo.CF_Cta_Cont(@Alias_H, @Fecha_Cbte))
			SET @Id_Centro_Costo = ''
			SET @NroItem = @NroItem + 1

			INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@ID_Cta_Haber,	@Fecha_Cbte,
				@IMPORTE, 0   /*HABER*/,				''/*Observacion*/,
				@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
				@NroItem)
				set @Total_Debe = @Total_Debe + @IMPORTE
			FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten,@IMPORTE,@Alias_H
		END 
		CLOSE curGenCtaCteDEBEPercep
		DEALLOCATE curGenCtaCteDEBEPercep			
 
		/*Insert: Cuenta Contable: HABER*/
		SET @Alias = 0
        SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
 
	    IF @Id_Moneda <>  CAST( dbo.CF_xParam('Moneda_Nacional') AS char(3)) AND @alias <> 0
     	   SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont_Venta_Dol FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
				   
		IF @Tomar_Asiento_Cbte = 0
		   BEGIN
	           IF(@pModoDebug = 1)
		           PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'AL DEBE @Tomar_Asiento_Cbte = 0'		 
				SET @Id_Cta_Contable = (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))
				--SET @Id_Cta_Contable = 0
				SET @Haber = (SELECT (C.Imp_total * C.cotizacion) FROM Cbtes C WHERE c.Id_Trans = @pId_Trans  )
				SET @NroItem = @NroItem + 1

		
				----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)
		 END

      IF @Tomar_Asiento_Cbte <> 0 or @Alias = 0
 	     BEGIN
		 	IF(@pModoDebug = 1)
		       PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'AL DEBE @Tomar_Asiento_Cbte = 1'	
			   
			SELECT * INTO #CTAS_AUX FROM CBTES_CTAS_CONTABLES WHERE 1 = 0

			SELECT A.Id_Trans, A.Id_Trans_D, A.IMPORTE, I.Alias as ALias ,I.DEBE,  I.HABER, C.Imp_Total
			        ,dbo.CF_Cta_Cont(I.Alias, @Fecha_Cbte) as Id_Cta_Contable, Convert(Int,0) as Item, T.Compromete_Factura, T.Compromete_Recibos
			       Into #CBTES_APLICA_AUX
			       FROM  Cbtes_Aplica A
				   LEFT JOIN Cbtes C ON C.Id_Trans = A.Id_Trans  AND  C.Id_Estado_Cbte NOT IN (0,3)
				   LEFT JOIN Cbtes_Ctas_Contables I ON I.ID_Trans = C.Id_Trans  
				   LEFT JOIN Cbtes_Tipos T on C.Id_Tipo_Cbte =  T.Id_Tipo_Cbte
				   WHERE A.Id_Trans_D = @pId_Trans  

			Update #CBTES_APLICA_AUX set Haber = ABS(isnull(Debe,0) * (Isnull(Importe,0)/isnull(Imp_Total,0))), DEBE = 0
			       WHERE Compromete_Factura = 1 

			Update #CBTES_APLICA_AUX set Debe = ABS(isnull(Haber,0) * (Isnull(Importe,0)/isnull(Imp_Total,0))), Haber = 0
			       WHERE (Compromete_Factura = -1  OR Compromete_Recibos IN (1,-1))

			--Update #CBTES_APLICA_AUX set DEBE = 0

			update #CBTES_APLICA_AUX set Alias = @Alias where Alias = 0


	        IF(@pModoDebug = 1)
		       PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'#CBTES_APLICA_AUX AGREGO IDENTITY'
	

            SELECT Alias,Id_cta_contable,SUM(DEBE) as debe, SUM(HABER) as haber, SUM(DEBE-HABER) AS DIF  
				INTO #ASIENTOS_DEBE_AUX 
                     FROM #CBTES_APLICA_AUX  group by Alias,Id_cta_contable having SUM(DEBE-HABER) <> 0

		    DELETE #ASIENTOS_DEBE_AUX WHERE DEBE = 0 AND HABER = 0
			   
			Alter table #ASIENTOS_DEBE_AUX add Item int, NroItem int identity(1,1)

			update #ASIENTOS_DEBE_AUX set Item  = NroItem + @NroItem
			update #ASIENTOS_DEBE_AUX set DEBE = 0, HABER = ABS(DIF) WHERE DIF < 0
			update #ASIENTOS_DEBE_AUX set DEBE = ABS(DIF), HABER = 0 WHERE DIF > 0

			INSERT INTO #CTAS_AUX
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
			Select 									
				@pId_Trans, Id_Cta_Contable,	@Fecha_Cbte,
				Debe,		Haber,				''/*Observacion*/,
				Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				Item From #ASIENTOS_DEBE_AUX Where Debe <> 0 or Haber <> 0

 	        IF(@pModoDebug = 1)
		       PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'AGREGO DETALLE'
			   PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Alias_a_Cta ' + CONVERT(VARCHAR(4),@Alias_a_Cta)
            DROP TABLE #CBTES_APLICA_AUX
			DROP TABLE #ASIENTOS_DEBE_AUX
			
				/* 03/04/2024 Maca POR FAVOR REVISAR!!!!!
					Se agegra el Total del Debe de Cbtes_Ctas_Contables 
					porque sino siempre ingresa por pago a cta y agrega un item de alias 0
				*/
				SET @Total_debe = (SELECT SUM(DEBE) FROM Cbtes_Ctas_Contables where Id_Trans=@pId_Trans) 
				SET @Total_haber = (SELECT sum(Haber)  FROM #CTAS_AUX )
                SET @Total_debe  = @Total_debe + (SELECT sum(Debe)  FROM #CTAS_AUX )

				SET @IMPORTE_Pago_Cta = @Total_debe - @Total_haber

				SELECT TOP 1 * INTO #CTAS_AUX_F_PAGO FROM #CTAS_AUX order by Item desc
				
				IF (@IMPORTE_Pago_Cta > 0)		
					BEGIN					
						UPDATE #CTAS_AUX_F_PAGO 
						SET
	                    Id_Cta_Contable = dbo.CF_Cta_Cont(@Alias_a_Cta, @Fecha_Cbte),
						Alias = @Alias_a_Cta,  
						Debe =  @IMPORTE_Pago_Cta,
						Haber = 0,
						Item  = Item+1

					    INSERT INTO #CTAS_AUX
					        SELECT * FROM #CTAS_AUX_F_PAGO

				    END

				IF (@IMPORTE_Pago_Cta < 0)		
					BEGIN					
						UPDATE #CTAS_AUX_F_PAGO 
						SET
						Id_Cta_Contable =  dbo.CF_Cta_Cont(@Alias_a_Cta, @Fecha_Cbte),
						Alias =  @Alias_a_Cta,  
						Debe = 0,
						Haber = ABS(@IMPORTE_Pago_Cta),
						Item  = Item+1
						 
					    INSERT INTO #CTAS_AUX
					        SELECT * FROM #CTAS_AUX_F_PAGO
				    END
				DROP TABLE #CTAS_AUX_F_PAGO	
					
				INSERT INTO Cbtes_Ctas_Contables 
				    SELECT * FROM #CTAS_AUX

  	            IF(@pModoDebug = 1)
		           PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN ASIENTO'           
	      END
	 
	END	
/*===================================================================*/	

IF(@pModoDebug = 1)
	PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Flag_Compromete_Compras: ' + CONVERT(VARCHAR(10), @Flag_Compromete_Compras)	

IF(@Flag_Compromete_Compras IN (1, -1))
BEGIN	
	IF(@pModoDebug = 1)
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Flag_Compromete_Compras'
		
	SELECT @Fecha = Fecha
			,@Id_Tipo_Cbte = Id_Tipo_Cbte
			,@Id_Proveedor = Id_Proveedor  
			,@Importe = Imp_TOTAL
			,@IMP_GRAVADO = Imp_Gravado + Imp_Gravado2 + Imp_Gravado3 + Imp_Exento
			,@IMP_IVA = Imp_Iva + Imp_Iva2 + Imp_Iva3
			FROM CBTES WHERE Id_Trans = @pId_Trans

	SET	@Id_Iva	= ISNULL((SELECT Id_Iva FROM Proveedores WHERE Id_Proveedor = @Id_Proveedor), 'I')
	SET @Signo = @Flag_Compromete_Compras
	SET @ASI_Comp_x_Items = CAST( dbo.CF_xParam('ASI_Comp_x_Items') AS INT)

	IF(@pModoDebug = 1)
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'@Signo: ' + CONVERT(VARCHAR(10), @Signo)

	DECLARE @Existe_Items SMALLINT
	SET @Existe_Items = ISNULL((select count(*) from cbtes_items where  Id_Trans = @pId_Trans),0)

	IF(@Existe_Items = 0)
	BEGIN
	   SET @ASI_Comp_x_Items = 0
	END

	SET @Alias_D = (SELECT Id_Cta_Contable_D FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
	SET @Alias_H = (SELECT Id_Cta_Contable_H FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)
	SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Cont_Iva_compras')

	SET @ID_Centro_Costo = (SELECT ID_Centro_Costo FROM PROVEEDORES WHERE ID_PROVEEDOR = @ID_PROVEEDOR)

	SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
	SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
	SET @ID_Cta_Haber = (SELECT dbo.CF_Cta_Cont(@Alias_H, @Fecha))
	SET @NroItem = 0
	/*FIN Asignacion Variables*/

	

	IF ISNULL(@ASI_Comp_x_Items,0) = 0          --Asiento por cabecerad e cbte.
	BEGIN
		IF @SIGNO > 0
		BEGIN	
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha, Debe, Haber, Observacion, Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Debe,	@Fecha,@IMP_GRAVADO,	0,	'',@Alias_D,0,	@ID_Centro_Costo,1)
			IF @Id_Iva IN ('I', 'RI')
			BEGIN
				INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,@IMP_IVA,	0,	'',@Alias_D_IVA,0,	'',2)
			END
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
									VALUES	(@pId_Trans,	@ID_Cta_Haber,	@Fecha,0,	@Importe,	'',@Alias_H,0,	'',3)
		END
		ELSE
		BEGIN
			SET @IMPORTE_NC = @IMPORTE*-1
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_Haber,	@Fecha,@Importe_NC,	0,	'',@Alias_H,0,	'',1)
			
			IF @Id_Iva IN ('I', 'RI')
			BEGIN
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,0,@IMP_IVA,	'',@Alias_D_IVA,0,	'',2)
			END
			INSERT INTO Cbtes_Ctas_Contables (Id_Trans,	Id_Cta_Contable,	Fecha,Debe, Haber, Observacion,Alias, Id_Asiento, Id_Centro_Costo, Item)
										VALUES	(@pId_Trans,	@ID_Cta_DEBE,	@Fecha,0,	@Importe_NC-@IMP_IVA,	'',@Alias_D,0,	@ID_Centro_Costo,3)
		END
	END
	ELSE
	BEGIN
		
		/*INICIO Insert: Cuenta Contable: DEBE*/		
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Productos'

		DECLARE curGenCtaContDEBE CURSOR FOR 

	    	SELECT P.Id_Alias_Cta_Asto_Costos,isnull(P.Id_Centro_Costo,'') AS Id_Centro_Costo,isnull(Sum(I.Imp_Gravado*@Signo),0) AS Imp_Gravado
	    	FROM Cbtes_Items i, Productos P
		    WHERE 
		    Id_Trans = @pId_Trans
	     	and I.id_Producto = P.Id_Producto
		    group by P.Id_Alias_Cta_Asto_Costos,P.Id_Centro_Costo

		    --PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion select del cursor'

		OPEN curGenCtaContDEBE
		FETCH NEXT FROM curGenCtaContDEBE INTO @Alias_D,@Id_Centro_Costo,@IMPORTE
		WHILE @@FETCH_STATUS = 0
		BEGIN
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @NroItem = @NroItem + 1
		
			--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) +  '. Alias: ' + CONVERT(VARCHAR(10), @Alias_D) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Debe) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 


					INSERT INTO Cbtes_Ctas_Contables
					(Id_Trans,		Id_Cta_Contable,	Fecha,
					Debe,			Haber,				Observacion,
					Alias,			Id_Asiento,			Id_Centro_Costo,
					Item)
					VALUES									
					(@pId_Trans,	@ID_Cta_Debe,	@Fecha,
					@Importe/*Debe*/,		0,				''/*Observacion*/,
					@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
					@NroItem)


			FETCH NEXT FROM curGenCtaContDEBE INTO  @Alias_D,@Id_Centro_Costo,@IMPORTE
		END 

		CLOSE curGenCtaContDEBE
		DEALLOCATE curGenCtaContDEBE

		/*FIN Insert: Cuenta Contable: DEBE*/
	
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Percepciones'	

		DECLARE curGenCtaCteDEBEPercep CURSOR FOR 
		
			SELECT DISTINCT Id_Tipo_Reten 
			FROM Cbtes_Reten 
			WHERE 
			Id_Trans = @pId_Trans

		OPEN curGenCtaCteDEBEPercep
		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @Alias_D = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
		    SET @ID_Cta_Debe = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))
			SET @Id_Centro_Costo = ''
			SET @IMPORTE = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1
		
			--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@ID_Cta_Debe,	@Fecha,
			@Importe/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

			FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteDEBEPercep
		DEALLOCATE curGenCtaCteDEBEPercep
	
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Iva'

		SET @Alias_D_IVA = (select Valor_INTEGER from xParametros where setDatos= 1 and idParametro ='Cta_Cont_Iva_compras')
        SET @ID_Centro_Costo = ''
        SET @ID_Cta_Debe_IVA = (SELECT dbo.CF_Cta_Cont(@Alias_D_IVA, @Fecha))
	
		IF(@IMP_IVA <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@ID_Cta_Debe_IVA,	@Fecha,
			@IMP_IVA/*Debe*/,		0,				''/*Observacion*/,
			@Alias_D_IVA,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END

		/*Insert: Cuenta Contable: HABER */
		

		SELECT @Importe = Imp_TOTAL	FROM CBTES WHERE Id_Trans = @pId_Trans

		SET @Id_Centro_Costo = (SELECT Isnull(Id_Centro_Costo,'') FROM Proveedores WHERE Id_PROVEEDOR = @ID_PROVEEDOR)
		SET @NroItem = @NroItem + 1
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias_H) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @ID_Cta_Haber) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
		INSERT INTO Cbtes_Ctas_Contables
		(Id_Trans,		Id_Cta_Contable,	Fecha,
		Debe,			Haber,				Observacion,
		Alias,			Id_Asiento,			Id_Centro_Costo,
		Item)
		VALUES									
		(@pId_Trans,	@ID_Cta_Haber,	@Fecha,
		0,@Importe ,			''/*Observacion*/,
		@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
		@NroItem)
		/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
	

	
		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN Compromete COMPRAS'
	END /*IF(@Flag_Compromete_COMPRAS)*/

END
/*************************************************************************************************/
--------Falta en pagos cuando es cta dol y diferencias de cambio
/*************************************************************************************************/

IF(@Flag_Compromete_Pagos = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Compromete Pagos'
		END
		SELECT 	@ID_PROVEEDOR = ISNULL(Id_Proveedor,0), 
				@Fecha		 = Fecha,	
				@Id_Centro_Costo = ISNULL(Id_Centro_Costo,'')			   
				FROM Cbtes WHERE Id_Trans= @pId_Trans
				
		SET @Id_Centro_Costo = '' -- En los pagos no se asigna CC
		SET @NroItem = 0
		
		IF(@ID_PROVEEDOR = 0) --Pagos Varios
		BEGIN
			/*Armo el Debe*/
			DECLARE curGenCtaCteDEBE CURSOR FOR
				SELECT  c.Id_Cta_Contable,(cc.Importe * -1) as importe
						FROM Cajas_Mov_Conceptos cc, Conceptos c 
						WHERE  cc.Id_Concepto=c.Id_Concepto 
						AND cc.id_trans=@pId_Trans
				
			OPEN curGenCtaCteDEBE
			FETCH NEXT FROM curGenCtaCteDEBE INTO @Alias_D,@IMPORTE
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @ID_Cta_Debe = dbo.CF_Cta_Cont(@Alias_D,@Fecha)
				SET @NroItem = @NroItem + 1
				
				INSERT INTO Cbtes_Ctas_Contables
						(Id_Trans,		Id_Cta_Contable,	Fecha,
						Debe,			Haber,				Observacion,
						Alias,			Id_Asiento,			Id_Centro_Costo,
						Item)
						VALUES									
						(@pId_Trans,	@ID_Cta_Debe,	@Fecha,
						@IMPORTE/*Debe*/,		0,				''/*Observacion*/,
						@Alias_D,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
						@NroItem)
	
			
				FETCH NEXT FROM curGenCtaCteDEBE INTO @Alias_D,@IMPORTE
			END 
			CLOSE curGenCtaCteDEBE
			DEALLOCATE curGenCtaCteDEBE
		END
		
		IF(@ID_PROVEEDOR <> 0) 
		BEGIN
			SELECT  @Alias_D = Id_Cta_Contable_D , @ID_Centro_Costo = ID_Centro_Costo ,@Alias_H = Id_Cta_Contable_H
					FROM PROVEEDORES 
					WHERE ID_PROVEEDOR = @ID_PROVEEDOR

			SET @IMPORTE = ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans > 0 ),0)
			SET @IMPORTE_Pago_Cta = ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans = 0 ),0)
			SET @IMPORTE_Pago_Cta_Tomado =  ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans < 0 ),0)

			SET @ID_Cta_Debe  = (SELECT dbo.CF_Cta_Cont(@Alias_D, @Fecha))


			/****************Pago a Cta **************************/
			IF @IMPORTE_Pago_Cta <> 0
			BEGIN
				SET @Alias_Pago_Cta = (dbo.CF_xParam('Cta_Anticipo_Prov'))
				IF @Alias_Pago_Cta = 0
					SET @Alias_Pago_Cta = @Alias_D
		
				SET @NroItem = @NroItem + 1
				INSERT INTO Cbtes_Ctas_Contables (Id_Trans,		  Id_Cta_Contable,	   	Fecha,
														  Debe,           Haber,				Observacion,
														  Alias,          Id_Asiento,			Id_Centro_Costo, Item)

						VALUES					 		 (@pId_Trans,	  (SELECT dbo.CF_Cta_Cont(@Alias_Pago_Cta, @Fecha)),		    @Fecha,
														  @IMPORTE_Pago_Cta,		  0,					'',
														  @Alias_Pago_Cta,       0,	                @ID_Centro_Costo,@NroItem)
			END
			/**************** FIN Pago a Cta **************************/
			
	    

			/**************** Facturas **************************/
			IF @IMPORTE > 0
			BEGIN		
			    SET @NroItem = @NroItem + 1
				INSERT INTO Cbtes_Ctas_Contables (Id_Trans,		  Id_Cta_Contable,	   	Fecha,
														  Debe,           Haber,				Observacion,
														  Alias,          Id_Asiento,			Id_Centro_Costo, Item)

						VALUES					 		 (@pId_Trans,	  @ID_Cta_Debe,		    @Fecha,
														  @IMPORTE,		  0,					'',
														  @Alias_D,       0,	                @ID_Centro_Costo,@NroItem)


		   END

			IF @IMPORTE_Pago_Cta_Tomado < 0
			BEGIN					
				SET @Alias_Pago_Cta = (dbo.CF_xParam('Cta_Anticipo_Prov'))
				IF @Alias_Pago_Cta = 0
					SET @Alias_Pago_Cta = @Alias_D
		
		        SET @NroItem = @NroItem + 1
				INSERT INTO Cbtes_Ctas_Contables (Id_Trans,		  Id_Cta_Contable,	   	Fecha,
														  Debe,           Haber,				Observacion,
														  Alias,          Id_Asiento,			Id_Centro_Costo, Item)

						VALUES					 		 (@pId_Trans,	  (SELECT dbo.CF_Cta_Cont(@Alias_Pago_Cta, @Fecha)),    @Fecha,
														  0,		  @IMPORTE_Pago_Cta,					'',
														  @Alias_Pago_Cta,       0,	                @ID_Centro_Costo,1)

		   END

		END




			-------------------------------------------------------------------Forma de PAgo
			
			/*Armo el Haber*/
			DECLARE curGenCtaCteHABER CURSOR FOR 
					SELECT V.Id_Tipo_Val, V.Importe,V.Id_Cta_Banco,V.Id_Moneda,B.Id_Cta_Contable,T.Id_Alias_Cta_Cont
							,O.Id_Alias_Cta_Cont,I.Id_Alias_Cta_Cont,V.Flag_Electronico,I.Id_Alias_Cta_Cont_Electr
							FROM Valores V 
								LEFT JOIN Bancos_Ctas B ON B.Id_Cta_Banco = V.Id_Cta_Banco
								LEFT JOIN Valores_Tarjetas_Cred T ON T.Id_Tarjeta = V.Id_Tarjeta
							     , Valores_Mov M
								 , Valores_Monedas O
								 , Valores_Tipos I
							WHERE M.Id_Trans = @pId_Trans
							AND V.Id_Valor = M.Id_Valor
							AND O.Id_Moneda = V.Id_Moneda
							AND I.Id_Tipo_Val = V.Id_Tipo_Val

			OPEN curGenCtaCteHABER
			FETCH NEXT FROM curGenCtaCteHABER 
					INTO @VAL_Id_Tipo_Val,@IMPORTE,@ID_CTA_BANCO,@Id_Moneda,@Alias,@Alias_H,@Alias_Monedas,@Alias_Tipo_Valor,@Flag_Electronico,@Alias_Tipo_Valor_Elec
			WHILE @@FETCH_STATUS = 0
			BEGIN

				/*************** Seteo personalizado por caja **************/
			    SET @Alias_H = ISNULL((SELECT Id_Alias_Cta_Cont FROM Cajas_Ctas_Cont 
									WHERE Id_Caja = @CP_Id_Caja AND Id_Tipo_Val = @VAL_Id_Tipo_Val  AND Id_Moneda = @Id_Moneda), 0)
				/*************** FIN Seteo personalizado por caja **************/

                IF @Alias_H = 0
				BEGIN
				
					IF (@VAL_Id_Tipo_Val IN ('CHP','DB','CTA') AND ISNULL(@ID_CTA_BANCO,0) <>0)
						SET @Alias_H  = @Alias
					IF (@VAL_Id_Tipo_Val IN ('TAR','CUP')) 
						SET @Alias_H  = @Alias_H   --lo dejo para que se entienda
			    END

				IF @Alias_H = 0 AND ISNULL(@Alias_Monedas,0) <> 0
					SET @Alias_H  = @Alias_Monedas

				IF @Alias_H = 0 AND ISNULL(@Alias_Tipo_Valor_Elec,0) <> 0 AND ISNULL(@Flag_Electronico,0) <> 0
					SET @Alias_H  = @Alias_Tipo_Valor_Elec	

				IF @Alias_H = 0 AND ISNULL(@Alias_Tipo_Valor,0) <> 0
					SET @Alias_H  = @Alias_Tipo_Valor						

				IF @Alias_H = 0  AND @CP_Id_Caja <> 0 
					SET @Alias_H  = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja ),0)	
					
				IF @Alias_H = 0  
					SET @Alias_H  = (dbo.CF_xParam('Cuenta_Caja'))

				SET @NroItem = @NroItem + 1
			
				SET @ID_Cta_Haber = dbo.CF_Cta_Cont(@Alias_H,@Fecha)
				INSERT INTO Cbtes_Ctas_Contables
						(Id_Trans,		Id_Cta_Contable,	Fecha,
						Debe,			Haber,				Observacion,
						Alias,			Id_Asiento,			Id_Centro_Costo,
						Item)
						VALUES									
						(@pId_Trans,	@ID_Cta_Haber,	@Fecha,
						0,				@IMPORTE,/*Haber*/				''/*Observacion*/,
						@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
						@NroItem)

				FETCH NEXT FROM curGenCtaCteHABER 
					INTO @VAL_Id_Tipo_Val,@IMPORTE,@ID_CTA_BANCO,@Id_Moneda,@Alias,@Alias_H,@Alias_Monedas,@Alias_Tipo_Valor,@Flag_Electronico,@Alias_Tipo_Valor_Elec
			END 
			CLOSE curGenCtaCteHABER
			DEALLOCATE curGenCtaCteHABER
			/********************************* Retencions    *********************/

		--PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Generacion de Items de Retencions Pagos'	

		DECLARE curGenCtaCteDEBEPercep CURSOR FOR 
			SELECT R.Id_Tipo_Reten,R.Importe,T.Id_Cta_Contable
					FROM Cbtes_Reten R, Cbtes_Reten_Tipos T
					WHERE R.Id_Trans = @pId_Trans AND R.Id_Tipo_Reten =  T.Id_Tipo_Reten

		OPEN curGenCtaCteDEBEPercep
		FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten,@IMPORTE,@Alias_H
		WHILE @@FETCH_STATUS = 0
		BEGIN
		    SET @ID_Cta_Haber = (SELECT dbo.CF_Cta_Cont(@Alias_H, @Fecha))
			SET @Id_Centro_Costo = ''
			SET @NroItem = @NroItem + 1

			INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@ID_Cta_Haber,	@Fecha,
				0/*Debe*/,		@IMPORTE,				''/*Observacion*/,
				@Alias_H,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
				@NroItem)

			FETCH NEXT FROM curGenCtaCteDEBEPercep INTO @Id_Tipo_Reten,@IMPORTE,@Alias_H
		END 
		CLOSE curGenCtaCteDEBEPercep
		DEALLOCATE curGenCtaCteDEBEPercep			




	
END	----PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'FIN Compromente Pagos'
	/*===================================================================*/	




   /*===================================================================*/		
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END
	
	/*===================================================================*/	

	IF (@pRtaMsjStored = 0)
	BEGIN

		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT') +
									'}'

		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage
	END 

	IF(@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(20),GETDATE(),126) +'Fin Stored Procedure: CPJ_Cbtes_Ctas_Contables_Generar'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo
	
	IF ISNULL(@pFlagUsarTrans,0) <> 0 
	BEGIN
		ROLLBACK
	END

	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber') ) = -1
	   DEALLOCATE curGenCtaCteHaber		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaber 
	   DEALLOCATE curGenCtaCteHaber		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaberPercep') ) = -1
	   DEALLOCATE curGenCtaCteHaberPercep		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaberPercep') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaberPercep
	   DEALLOCATE curGenCtaCteHaberPercep		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteDebe_CMC') ) = -1
	   DEALLOCATE curGenCtaCteDebe_CMC		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteDebe_CMC') ) = 1
	BEGIN
	   CLOSE curGenCtaCteDebe_CMC
	   DEALLOCATE curGenCtaCteDebe_CMC 		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber_Val') ) = -1
	   DEALLOCATE curGenCtaCteHaber_Val		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaCteHaber_Val') ) = 1
	BEGIN
	   CLOSE curGenCtaCteHaber_Val
	   DEALLOCATE curGenCtaCteHaber_Val		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_Val') ) = -1
	   DEALLOCATE curGenCtaDEBE_Val		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_Val') ) = 1
	BEGIN
	   CLOSE curGenCtaDEBE_Val
	   DEALLOCATE curGenCtaDEBE_Val		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = -1
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = 1
	BEGIN
	   CLOSE curGenCtaDEBE_FAC_APLIC2
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 
	END
	---------------------------------------------------------------------------------------


	RETURN 9999
END CATCH

RETURN 0
